/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.ponder.content.fluid;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.contraptions.fluids.PumpBlock;
import com.simibubi.create.content.contraptions.fluids.actors.ItemDrainTileEntity;
import com.simibubi.create.content.contraptions.fluids.pipes.AxisPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.FluidValveTileEntity;
import com.simibubi.create.content.contraptions.fluids.pipes.GlassFluidPipeBlock;
import com.simibubi.create.content.contraptions.fluids.pipes.SmartFluidPipeTileEntity;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import com.simibubi.create.content.contraptions.processing.BasinTileEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.element.WorldSectionElement;
import com.simibubi.create.foundation.tileEntity.behaviour.fluid.SmartFluidTankBehaviour;
import com.simibubi.create.foundation.utility.Pointing;
import com.tterrag.registrate.fabric.SimpleFlowableFluid;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import io.github.tropheusj.milk.Milk;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4481;

public class PipeScenes {
    public static void flow(SceneBuilder scene, SceneBuildingUtil util) {
        int i;
        scene.title("fluid_pipe_flow", "Moving Fluids using Copper Pipes");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        class_2680 pipeState = (class_2680)((class_2680)AllBlocks.FLUID_PIPE.getDefaultState().method_11657((class_2769)FluidPipeBlock.field_11327, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FluidPipeBlock.field_11330, (Comparable)Boolean.valueOf(false));
        scene.world.setBlock(util.grid.at(2, 1, 1), (class_2680)((class_2680)pipeState.method_11657((class_2769)FluidPipeBlock.field_11332, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FluidPipeBlock.field_11331, (Comparable)Boolean.valueOf(false)), false);
        scene.world.setBlock(util.grid.at(1, 1, 2), (class_2680)((class_2680)pipeState.method_11657((class_2769)FluidPipeBlock.field_11328, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FluidPipeBlock.field_11335, (Comparable)Boolean.valueOf(false)), false);
        Selection largeCog = util.select.position(5, 0, 1);
        Selection kinetics = util.select.fromTo(5, 1, 0, 3, 1, 0);
        Selection tank = util.select.fromTo(4, 1, 2, 4, 2, 2);
        Selection tank2 = util.select.fromTo(0, 1, 3, 0, 2, 3);
        Selection strayPipes = util.select.fromTo(2, 1, 2, 2, 2, 2).add(util.select.fromTo(1, 2, 2, 1, 3, 2));
        scene.world.showSection(tank, class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(tank2, class_2350.field_11033);
        FluidStack content = new FluidStack((class_3611)class_3612.field_15908, 10000L);
        scene.world.modifyTileEntity(util.grid.at(4, 1, 2), FluidTankTileEntity.class, te -> TransferUtil.insertFluid((Storage)te.getTankInventory(), (FluidStack)content));
        scene.idle(10);
        for (i = 4; i >= 1; --i) {
            scene.world.showSection(util.select.position(i, 1, 1), i == 4 ? class_2350.field_11035 : class_2350.field_11034);
            scene.idle(3);
        }
        scene.overlay.showText(60).text("Fluid Pipes can connect two or more fluid sources and targets").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(1, 1, 1));
        for (i = 2; i <= 3; ++i) {
            scene.world.showSection(util.select.position(1, 1, i), class_2350.field_11043);
            scene.idle(3);
        }
        scene.idle(60);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(2, 1, 1), Pointing.DOWN).rightClick().withWrench(), 40);
        scene.idle(7);
        scene.world.restoreBlocks(util.select.position(2, 1, 1));
        scene.overlay.showText(70).attachKeyFrame().pointAt(util.vector.centerOf(2, 1, 1)).placeNearTarget().text("Using a wrench, a straight pipe segment can be given a window");
        scene.idle(40);
        scene.overlay.showControls(new InputWindowElement(util.vector.centerOf(1, 1, 2), Pointing.DOWN).rightClick().withWrench(), 10);
        scene.idle(7);
        scene.world.restoreBlocks(util.select.position(1, 1, 2));
        scene.idle(40);
        class_243 center = util.vector.centerOf(2, 1, 2);
        class_238 bb = new class_238(center, center).method_1014(0.1666666716337204);
        class_238 bb1 = bb.method_989(-0.5, 0.0, 0.0);
        class_238 bb2 = bb.method_989(0.0, 0.0, -0.5);
        scene.world.showSection(strayPipes, class_2350.field_11033);
        scene.idle(10);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, bb1, bb, 1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, bb2, bb, 1);
        scene.idle(1);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, bb1, bb1, 50);
        scene.overlay.chaseBoundingBoxOutline(PonderPalette.RED, bb2, bb2, 50);
        scene.idle(10);
        scene.overlay.showText(55).attachKeyFrame().pointAt(util.vector.centerOf(2, 1, 2)).placeNearTarget().colored(PonderPalette.RED).text("Windowed pipes will not connect to any other adjacent pipe segments");
        scene.idle(60);
        scene.world.hideSection(strayPipes, class_2350.field_11036);
        scene.idle(10);
        class_2338 pumpPos = util.grid.at(3, 1, 1);
        scene.world.setBlock(pumpPos, (class_2680)AllBlocks.MECHANICAL_PUMP.getDefaultState().method_11657((class_2769)PumpBlock.FACING, (Comparable)class_2350.field_11039), true);
        scene.idle(10);
        scene.world.showSection(largeCog, class_2350.field_11036);
        scene.world.showSection(kinetics, class_2350.field_11035);
        scene.idle(10);
        scene.world.setKineticSpeed(util.select.position(pumpPos), 32.0f);
        scene.world.propagatePipeChange(pumpPos);
        scene.overlay.showText(70).attachKeyFrame().pointAt(util.vector.topOf(pumpPos)).placeNearTarget().text("Powered by Mechanical Pumps, the Pipes can transport Fluids");
        scene.idle(85);
        scene.overlay.showSelectionWithText(tank, 40).colored(PonderPalette.RED).placeNearTarget().text("No fluid is being extracted at first");
        scene.idle(90);
        scene.overlay.showOutline(PonderPalette.GREEN, new Object(), tank, 100);
        scene.idle(5);
        scene.overlay.showOutline(PonderPalette.GREEN, new Object(), tank2, 100);
        scene.idle(5);
        scene.overlay.showText(100).attachKeyFrame().independent().text("Once the flow connects them, the endpoints gradually transfer their contents");
        scene.overlay.showLine(PonderPalette.GREEN, util.vector.blockSurface(util.grid.at(4, 2, 2), class_2350.field_11039), util.vector.blockSurface(util.grid.at(0, 2, 3), class_2350.field_11034), 80);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), 2.0f);
        scene.world.propagatePipeChange(pumpPos);
        scene.effects.rotationSpeedIndicator(pumpPos);
        scene.idle(120);
        scene.overlay.showText(60).text("Thus, the Pipe blocks themselves never 'physically' contain any fluid").placeNearTarget().pointAt(util.vector.topOf(1, 1, 1));
        scene.idle(50);
    }

    public static void interaction(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("fluid_pipe_interaction", "Draining and Filling fluid containers");
        scene.configureBasePlate(0, 1, 5);
        scene.showBasePlate();
        scene.idle(5);
        class_2338 pumpPos = util.grid.at(2, 1, 4);
        Selection largeCog = util.select.position(5, 0, 4);
        Selection kinetics = util.select.fromTo(5, 1, 5, 2, 1, 5);
        Selection pipes = util.select.fromTo(1, 1, 4, 3, 1, 3).add(util.select.position(3, 1, 2));
        Selection tank = util.select.fromTo(4, 1, 3, 4, 2, 3);
        Selection drain = util.select.position(1, 1, 2);
        Selection basin = util.select.position(3, 1, 1);
        Selection waterSourceS = util.select.position(1, 1, 1);
        Selection waterTargetS = util.select.position(4, 1, 1);
        Selection waterTarget2S = util.select.fromTo(4, 0, 0, 4, 1, 0);
        scene.world.setKineticSpeed(util.select.position(pumpPos), 0.0f);
        scene.world.showSection(pipes, class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(basin, class_2350.field_11035);
        scene.idle(5);
        scene.world.showSection(drain, class_2350.field_11035);
        scene.idle(5);
        scene.world.showSection(tank, class_2350.field_11039);
        scene.overlay.showText(60).text("Endpoints of a pipe network can interact with a variety of blocks").attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(1, 1, 3), class_2350.field_11043));
        scene.idle(60);
        scene.world.showSection(largeCog, class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(kinetics, class_2350.field_11043);
        scene.idle(10);
        scene.world.setKineticSpeed(util.select.position(pumpPos), 64.0f);
        class_2338 drainPos = util.grid.at(1, 1, 2);
        scene.world.modifyTileEntity(drainPos, ItemDrainTileEntity.class, te -> TransferUtil.insert((Storage)te.getBehaviour(SmartFluidTankBehaviour.TYPE).allowInsertion().getPrimaryHandler(), (Object)FluidVariant.of((class_3611)class_3612.field_15910), (long)121500L));
        scene.idle(50);
        scene.overlay.showOutline(PonderPalette.MEDIUM, new Object(), drain, 40);
        scene.idle(5);
        scene.overlay.showOutline(PonderPalette.MEDIUM, new Object(), tank, 40);
        scene.idle(5);
        scene.overlay.showOutline(PonderPalette.MEDIUM, new Object(), basin, 40);
        scene.idle(5);
        scene.overlay.showText(60).text("Any block with fluid storage capabilities can be filled or drained").attachKeyFrame().colored(PonderPalette.MEDIUM).placeNearTarget().pointAt(util.vector.blockSurface(drainPos, class_2350.field_11036));
        scene.idle(100);
        scene.world.hideSection(drain, class_2350.field_11043);
        scene.idle(5);
        scene.world.hideSection(tank, class_2350.field_11034);
        scene.idle(5);
        scene.world.setBlock(drainPos, class_2246.field_10124.method_9564(), false);
        scene.world.propagatePipeChange(pumpPos);
        scene.world.hideSection(basin, class_2350.field_11043);
        scene.idle(5);
        scene.world.setBlock(util.grid.at(3, 1, 1), class_2246.field_10124.method_9564(), false);
        scene.idle(5);
        scene.world.setBlock(util.grid.at(3, 1, 3), (class_2680)AllBlocks.GLASS_FLUID_PIPE.getDefaultState().method_11657((class_2769)AxisPipeBlock.field_11459, (Comparable)class_2350.class_2351.field_11051), false);
        scene.idle(10);
        scene.world.multiplyKineticSpeed(util.select.everywhere(), 2.0f);
        scene.world.propagatePipeChange(pumpPos);
        ElementLink<WorldSectionElement> water = scene.world.showIndependentSection(waterSourceS, class_2350.field_11033);
        scene.world.moveSection(water, util.vector.of(0.0, 0.0, 1.0), 0);
        scene.idle(10);
        scene.world.setBlock(drainPos, class_2246.field_10382.method_9564(), false);
        scene.idle(20);
        scene.overlay.showText(60).text("Source blocks right in front of an open end can be picked up...").attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(drainPos, class_2350.field_11035));
        scene.idle(40);
        scene.world.setBlock(drainPos.method_10095(), class_2246.field_10124.method_9564(), false);
        scene.idle(40);
        ElementLink<WorldSectionElement> target = scene.world.showIndependentSection(waterTargetS, class_2350.field_11036);
        scene.world.moveSection(target, util.vector.of(-1.0, 0.0, 0.0), 0);
        scene.idle(5);
        scene.world.showSectionAndMerge(waterTarget2S, class_2350.field_11036, target);
        scene.overlay.showText(60).text("...while spilling into empty spaces can create fluid sources").attachKeyFrame().placeNearTarget().pointAt(util.vector.blockSurface(util.grid.at(3, 1, 2), class_2350.field_11043));
        scene.idle(80);
        scene.world.hideIndependentSection(target, class_2350.field_11033);
        scene.idle(5);
        scene.world.setBlock(drainPos, (class_2680)class_2246.field_20421.method_9564().method_11657((class_2769)class_4481.field_20420, (Comparable)Integer.valueOf(5)), false);
        scene.world.showSection(drain, class_2350.field_11033);
        scene.world.setBlock(util.grid.at(3, 1, 2), AllBlocks.FLUID_TANK.getDefaultState(), false);
        scene.world.propagatePipeChange(pumpPos);
        scene.idle(15);
        scene.overlay.showText(60).text("Pipes can also extract fluids from a handful of other blocks directly").attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(drainPos));
        scene.idle(60);
        scene.world.setBlock(drainPos, (class_2680)class_2246.field_20421.method_9564().method_11657((class_2769)class_4481.field_20420, (Comparable)Integer.valueOf(0)), false);
    }

    public static void encasing(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("encased_fluid_pipe", "Encasing Fluid Pipes");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        scene.world.showSection(util.select.position(2, 0, 5), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.layer(1), class_2350.field_11033);
        scene.idle(15);
        class_2680 copperEncased = (class_2680)((class_2680)AllBlocks.ENCASED_FLUID_PIPE.getDefaultState().method_11657((class_2769)FluidPipeBlock.field_11331, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)FluidPipeBlock.field_11328, (Comparable)Boolean.valueOf(true));
        class_1799 casingItem = AllBlocks.COPPER_CASING.asStack();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(3, 1, 1), Pointing.DOWN).rightClick().withItem(casingItem), 60);
        scene.idle(7);
        scene.world.setBlock(util.grid.at(3, 1, 1), copperEncased, true);
        scene.idle(10);
        scene.overlay.showText(60).placeNearTarget().text("Copper Casing can be used to decorate Fluid Pipes").attachKeyFrame().pointAt(util.vector.topOf(3, 1, 1));
        scene.idle(70);
        scene.world.destroyBlock(util.grid.at(2, 1, 1));
        scene.world.modifyBlock(util.grid.at(1, 1, 1), s -> (class_2680)((class_2680)s.method_11657((class_2769)FluidPipeBlock.field_11335, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)FluidPipeBlock.field_11332, (Comparable)Boolean.valueOf(true)), false);
        scene.idle(5);
        scene.overlay.showLine(PonderPalette.RED, util.vector.of(1.5, 1.75, 1.0), util.vector.of(1.5, 1.75, 2.0), 80);
        scene.idle(5);
        scene.addKeyframe();
        scene.overlay.showLine(PonderPalette.GREEN, util.vector.of(3.5, 2.0, 1.5), util.vector.of(3.5, 2.0, 2.0), 80);
        scene.overlay.showLine(PonderPalette.GREEN, util.vector.of(3.0, 2.0, 1.5), util.vector.of(3.5, 2.0, 1.5), 80);
        scene.idle(25);
        scene.overlay.showText(60).placeNearTarget().text("Aside from being conceiled, Encased Pipes are locked into their connectivity state").pointAt(util.vector.blockSurface(util.grid.at(3, 1, 1), class_2350.field_11039));
        scene.idle(70);
        class_2680 defaultState = AllBlocks.FLUID_PIPE.getDefaultState();
        for (class_2746 booleanProperty : FluidPipeBlock.field_11329.values()) {
            defaultState = (class_2680)defaultState.method_11657((class_2769)booleanProperty, (Comparable)Boolean.valueOf(false));
        }
        scene.world.setBlock(util.grid.at(3, 2, 1), (class_2680)((class_2680)defaultState.method_11657((class_2769)FluidPipeBlock.field_11335, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)FluidPipeBlock.field_11328, (Comparable)Boolean.valueOf(true)), false);
        scene.world.setBlock(util.grid.at(1, 2, 1), (class_2680)((class_2680)defaultState.method_11657((class_2769)FluidPipeBlock.field_11327, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)FluidPipeBlock.field_11330, (Comparable)Boolean.valueOf(true)), false);
        scene.world.showSection(util.select.layer(2), class_2350.field_11033);
        scene.idle(10);
        scene.world.modifyBlock(util.grid.at(1, 1, 1), s -> (class_2680)((class_2680)s.method_11657((class_2769)FluidPipeBlock.field_11327, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)FluidPipeBlock.field_11332, (Comparable)Boolean.valueOf(false)), false);
        scene.idle(20);
        scene.overlay.showText(60).placeNearTarget().colored(PonderPalette.RED).text("It will no longer react to any neighbouring blocks being added or removed").attachKeyFrame().pointAt(util.vector.centerOf(3, 2, 1));
        scene.idle(20);
    }

    public static void valve(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("valve_pipe", "Controlling Fluid flow using Valves");
        scene.configureBasePlate(0, 0, 5);
        scene.showBasePlate();
        Selection cogs = util.select.fromTo(5, 0, 2, 5, 1, 2);
        Selection tank1 = util.select.fromTo(3, 1, 3, 3, 2, 3);
        Selection tank2 = util.select.fromTo(1, 1, 3, 1, 2, 3);
        class_2338 valvePos = util.grid.at(2, 1, 1);
        class_2338 handlePos = util.grid.at(2, 2, 1);
        class_2338 pumpPos = util.grid.at(4, 1, 2);
        Selection pipes1 = util.select.fromTo(4, 1, 3, 4, 1, 1);
        Selection pipes2 = util.select.fromTo(3, 1, 1, 1, 1, 1);
        Selection pipes3 = util.select.fromTo(0, 1, 1, 0, 1, 3);
        scene.world.setKineticSpeed(pipes1, 0.0f);
        scene.world.propagatePipeChange(pumpPos);
        scene.world.setBlock(valvePos, ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).getAxisState(class_2350.class_2351.field_11048), false);
        scene.world.setBlock(util.grid.at(3, 1, 1), class_2246.field_10124.method_9564(), false);
        scene.world.setBlock(util.grid.at(3, 1, 1), (class_2680)AllBlocks.GLASS_FLUID_PIPE.getDefaultState().method_11657((class_2769)GlassFluidPipeBlock.field_11459, (Comparable)class_2350.class_2351.field_11048), false);
        scene.idle(5);
        scene.world.showSection(tank1, class_2350.field_11043);
        scene.idle(5);
        scene.world.showSection(tank2, class_2350.field_11043);
        scene.idle(10);
        scene.world.showSection(pipes1, class_2350.field_11039);
        scene.idle(5);
        scene.world.showSection(pipes2, class_2350.field_11035);
        scene.idle(5);
        scene.world.showSection(pipes3, class_2350.field_11034);
        scene.idle(15);
        scene.world.destroyBlock(valvePos);
        scene.world.restoreBlocks(util.select.position(valvePos));
        scene.overlay.showText(60).placeNearTarget().text("Valve pipes help control fluids propagating through pipe networks").attachKeyFrame().pointAt(util.vector.blockSurface(valvePos, class_2350.field_11039));
        scene.idle(75);
        scene.world.showSection(cogs, class_2350.field_11039);
        scene.idle(10);
        scene.world.setKineticSpeed(util.select.position(pumpPos), 64.0f);
        scene.world.propagatePipeChange(pumpPos);
        scene.overlay.showText(60).placeNearTarget().text("Their shaft input controls whether fluid is currently allowed through").attachKeyFrame().pointAt(util.vector.topOf(valvePos));
        scene.idle(60);
        scene.world.showSection(util.select.position(handlePos), class_2350.field_11033);
        scene.idle(15);
        Selection valveKinetics = util.select.fromTo(2, 1, 1, 2, 2, 1);
        scene.world.setKineticSpeed(valveKinetics, 16.0f);
        scene.effects.rotationSpeedIndicator(handlePos);
        scene.world.modifyTileEntity(valvePos, FluidValveTileEntity.class, te -> te.onSpeedChanged(0.0f));
        scene.idle(22);
        scene.world.modifyBlock(valvePos, s -> (class_2680)s.method_11657((class_2769)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(true)), false);
        scene.effects.indicateSuccess(valvePos);
        scene.idle(5);
        scene.world.setKineticSpeed(valveKinetics, 0.0f);
        scene.overlay.showText(60).placeNearTarget().text("Given Rotational Force in the opening direction, the valve will open up").attachKeyFrame().pointAt(util.vector.blockSurface(valvePos, class_2350.field_11043));
        scene.idle(90);
        scene.overlay.showText(50).placeNearTarget().text("It can be closed again by reversing the input rotation").attachKeyFrame().pointAt(util.vector.blockSurface(valvePos, class_2350.field_11043));
        scene.idle(40);
        scene.world.setKineticSpeed(valveKinetics, -16.0f);
        scene.effects.rotationSpeedIndicator(handlePos);
        scene.world.modifyTileEntity(valvePos, FluidValveTileEntity.class, te -> te.onSpeedChanged(0.0f));
        scene.idle(22);
        scene.world.modifyBlock(valvePos, s -> (class_2680)s.method_11657((class_2769)FluidValveBlock.ENABLED, (Comparable)Boolean.valueOf(false)), false);
        scene.effects.indicateRedstone(valvePos);
        scene.world.propagatePipeChange(pumpPos);
        scene.idle(5);
        scene.world.setKineticSpeed(valveKinetics, 0.0f);
    }

    public static void smart(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("smart_pipe", "Controlling Fluid flow using Smart Pipes");
        scene.configureBasePlate(1, 0, 5);
        scene.showBasePlate();
        scene.idle(5);
        Selection tank1 = util.select.fromTo(4, 1, 3, 4, 2, 3);
        Selection tank2 = util.select.fromTo(4, 1, 4, 4, 2, 4);
        Selection additionalPipes = util.select.fromTo(3, 1, 4, 1, 1, 4);
        Selection mainPipes = util.select.fromTo(3, 1, 3, 1, 1, 1);
        Selection kinetics1 = util.select.fromTo(0, 0, 2, 0, 0, 5);
        Selection kinetics2 = util.select.position(1, 0, 5);
        class_2338 basinPos = util.grid.at(4, 1, 1);
        class_2338 pumpPos = util.grid.at(1, 1, 2);
        Selection pump = util.select.position(1, 1, 2);
        Selection basin = util.select.position(basinPos);
        class_2338 smartPos = util.grid.at(3, 1, 1);
        scene.world.modifyTileEntity(basinPos, BasinTileEntity.class, te -> TransferUtil.insert(te.getFluidStorage(null), (Object)FluidVariant.of((class_3611)Milk.STILL_MILK), (long)81000L));
        scene.world.setBlock(util.grid.at(3, 1, 3), ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).getAxisState(class_2350.class_2351.field_11048), false);
        scene.world.setBlock(smartPos, ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).getAxisState(class_2350.class_2351.field_11048), false);
        scene.world.setBlock(util.grid.at(2, 1, 3), (class_2680)AllBlocks.GLASS_FLUID_PIPE.getDefaultState().method_11657((class_2769)GlassFluidPipeBlock.field_11459, (Comparable)class_2350.class_2351.field_11048), false);
        scene.world.setBlock(util.grid.at(1, 1, 3), (class_2680)((class_2680)((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).getAxisState(class_2350.class_2351.field_11048).method_11657((class_2769)FluidPipeBlock.field_11332, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)FluidPipeBlock.field_11328, (Comparable)Boolean.valueOf(false)), false);
        scene.world.showSection(basin, class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(tank1, class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(mainPipes, class_2350.field_11034);
        scene.idle(15);
        scene.world.destroyBlock(smartPos);
        scene.world.restoreBlocks(util.select.position(smartPos));
        class_243 filterVec = util.vector.topOf(smartPos).method_1023(0.25, 0.0, 0.0);
        scene.overlay.showText(50).placeNearTarget().text("Smart pipes can help control flows by fluid type").attachKeyFrame().pointAt(filterVec);
        scene.idle(60);
        scene.overlay.showSelectionWithText(util.select.position(basinPos), 80).placeNearTarget().colored(PonderPalette.GREEN).text("When placed directly at the source, they can specify the type of fluid to extract").attachKeyFrame().pointAt(filterVec);
        scene.idle(90);
        FluidStack chocolate = new FluidStack(FluidHelper.convertToStill((class_3611)AllFluids.CHOCOLATE.get()), 81000L);
        class_1799 bucket = ((SimpleFlowableFluid.Flowing)AllFluids.CHOCOLATE.get()).method_15774().method_7854();
        class_1799 milkBucket = new class_1799((class_1935)class_1802.field_8103);
        scene.overlay.showControls(new InputWindowElement(filterVec, Pointing.DOWN).rightClick().withItem(bucket), 80);
        scene.idle(7);
        scene.world.setFilterData(util.select.position(3, 1, 1), SmartFluidPipeTileEntity.class, bucket);
        scene.idle(10);
        scene.overlay.showText(60).placeNearTarget().attachKeyFrame().text("Simply Right-Click their filter slot with any item containing the desired fluid").pointAt(filterVec);
        scene.idle(50);
        scene.world.showSection(kinetics2, class_2350.field_11039);
        scene.world.setKineticSpeed(kinetics2, 64.0f);
        scene.idle(5);
        scene.world.showSection(kinetics1, class_2350.field_11034);
        scene.world.setKineticSpeed(kinetics1, -64.0f);
        scene.idle(10);
        scene.world.setKineticSpeed(pump, 128.0f);
        scene.world.propagatePipeChange(pumpPos);
        scene.idle(120);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.world.propagatePipeChange(pumpPos);
        scene.effects.rotationSpeedIndicator(pumpPos);
        scene.idle(15);
        scene.world.showSection(tank2, class_2350.field_11033);
        scene.world.showSection(additionalPipes, class_2350.field_11043);
        scene.world.setBlock(util.grid.at(3, 1, 1), ((FluidPipeBlock)AllBlocks.FLUID_PIPE.get()).getAxisState(class_2350.class_2351.field_11048), true);
        scene.idle(10);
        for (int i = 0; i < 3; ++i) {
            class_2338 pos = util.grid.at(1 + i, 1, 3);
            scene.world.destroyBlock(pos);
            scene.world.restoreBlocks(util.select.position(pos));
            scene.idle(2);
        }
        scene.idle(15);
        scene.world.modifyTileEntity(basinPos, BasinTileEntity.class, te -> TransferUtil.insertFluid(te.getFluidStorage(null), (FluidStack)chocolate));
        scene.idle(10);
        scene.overlay.showText(80).placeNearTarget().colored(PonderPalette.GREEN).text("When placed further down a pipe network, smart pipes will only let matching fluids continue").attachKeyFrame().pointAt(filterVec.method_1031(-1.0, 0.0, 2.0));
        scene.idle(90);
        scene.overlay.showControls(new InputWindowElement(filterVec.method_1031(-1.0, 0.0, 3.0), Pointing.DOWN).rightClick().withItem(milkBucket), 30);
        scene.idle(7);
        scene.world.setFilterData(util.select.position(2, 1, 4), SmartFluidPipeTileEntity.class, milkBucket);
        scene.idle(30);
        scene.overlay.showControls(new InputWindowElement(filterVec.method_1031(-1.0, 0.0, 2.0), Pointing.DOWN).rightClick().withItem(bucket), 30);
        scene.idle(7);
        scene.world.setFilterData(util.select.position(2, 1, 3), SmartFluidPipeTileEntity.class, bucket);
        scene.idle(30);
        scene.world.setKineticSpeed(kinetics2, 64.0f);
        scene.world.setKineticSpeed(kinetics1, -64.0f);
        scene.world.setKineticSpeed(pump, 128.0f);
        scene.world.propagatePipeChange(pumpPos);
        scene.effects.rotationSpeedIndicator(pumpPos);
        scene.idle(40);
    }
}

